package w83b.w83bOperacionesInternas.w83bMantenimientos.w83bUsuarios;


import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bBeans.W83bUsuariosBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class W83bDetalleSindicatosOIAction.
 * 
 * @author a
 */
public class W83bDetalleUsuariosOIAction extends Q70OperacionInterna{
	
	/**
	 * preProcessMappingEntrada.
	 * 
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{
		
		W83bUsuariosBean w83bUsuariosNuevoBean = (W83bUsuariosBean)contexto.get("w83bUsuariosNuevoBean");//NOPMD
		
		if(StringUtils.isNotEmpty((String)contexto.get("codSelec"))){
			w83bUsuariosNuevoBean.setDni( (String)contexto.get("codSelec"));
		}
		if(StringUtils.isNotEmpty((String)contexto.get("fechaBajaUsuario"))){
			w83bUsuariosNuevoBean.setFechaBaja((String)contexto.get("fechaBajaUsuario"));
		}
		contexto.set("w83bUsuariosNuevoBean",w83bUsuariosNuevoBean);
		
				
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida.
	 * 
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
		contexto.set("migas","inicio.mantenimiento.usuarios.edicionUsuario");
		
		W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
		if(W83bClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES.equals(usuario.getPermisoXlnet())){
			contexto.set("strTitleKey","comun.usuarios.editarUsuario");
		}else{
			contexto.set("strTitleKey","comun.usuarios.consultarUsuario");
		}
		
		contexto.set("strTitleKeyPpal","comun.menu.usuarios");
		
		W83bUsuariosBean w83bUsuariosNuevoBean = (W83bUsuariosBean)contexto.get("w83bUsuariosNuevoBean");//NOPMD
		
		contexto.set("w83bUsuariosNuevoBean",w83bUsuariosNuevoBean);
		contexto.set("w83bUsuariosNuevoTempBean",contexto.get("w83bUsuariosNuevoBean"));
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
}
